<?php
require_once 'includes/layout.php';

$action = $_GET['action'] ?? 'list';
$id = intval($_GET['id'] ?? 0);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $description = trim($_POST['description'] ?? '');
    $sortOrder = intval($_POST['sort_order'] ?? 0);

    if (empty($name)) {
        flash('error', 'Category name is required.');
    } else {
        $data = ['name' => $name, 'description' => $description, 'sort_order' => $sortOrder];

        if ($action === 'edit' && $id) {
            update('categories', $data, 'id = :wid', ['wid' => $id]);
            flash('success', 'Category updated.');
        } else {
            insert('categories', $data);
            flash('success', 'Category created.');
        }
        redirect('categories.php');
    }
}

if ($action === 'delete' && $id) {
    delete('categories', 'id = ?', [$id]);
    flash('success', 'Category deleted.');
    redirect('categories.php');
}

$editItem = null;
if ($action === 'edit' && $id) {
    $editItem = fetchOne("SELECT * FROM categories WHERE id = ?", [$id]);
    if (!$editItem) { redirect('categories.php'); }
}

adminHeader('Categories');
?>

<?php if ($flashErr = flash('error')): ?>
<div class="alert alert-error"><?= htmlspecialchars($flashErr) ?></div>
<?php endif; ?>
<?php if ($flashOk = flash('success')): ?>
<div class="alert alert-success"><?= htmlspecialchars($flashOk) ?></div>
<?php endif; ?>

<?php if ($action === 'add' || $action === 'edit'): ?>
<div class="page-header">
    <h2><?= $action === 'edit' ? 'Edit' : 'Add' ?> Category</h2>
    <a href="categories.php" class="btn btn-outline btn-small">Back to List</a>
</div>

<div class="form-card">
    <form method="post">
        <div class="form-group">
            <label>Category Name *</label>
            <input type="text" name="name" value="<?= htmlspecialchars($editItem['name'] ?? '') ?>" required>
        </div>
        <div class="form-group">
            <label>Description</label>
            <textarea name="description"><?= htmlspecialchars($editItem['description'] ?? '') ?></textarea>
        </div>
        <div class="form-group">
            <label>Sort Order</label>
            <input type="number" name="sort_order" value="<?= $editItem['sort_order'] ?? 0 ?>">
        </div>
        <button type="submit" class="btn"><?= $action === 'edit' ? 'Update' : 'Create' ?> Category</button>
    </form>
</div>

<?php else: ?>
<div class="page-header">
    <h2>Categories</h2>
    <a href="categories.php?action=add" class="btn">Add Category</a>
</div>

<?php
$categories = getCategories();
if (empty($categories)):
?>
<p style="color:var(--gray);">No categories yet. Add your first category.</p>
<?php else: ?>
<table class="data-table">
    <thead>
        <tr>
            <th>Name</th>
            <th>Description</th>
            <th>Subcategories</th>
            <th>Products</th>
            <th>Order</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
    <?php foreach ($categories as $cat):
        $sc = fetchOne("SELECT COUNT(*) as cnt FROM subcategories WHERE category_id = ?", [$cat['id']])['cnt'];
        $pc = fetchOne("SELECT COUNT(*) as cnt FROM products p JOIN subcategories s ON p.subcategory_id = s.id WHERE s.category_id = ?", [$cat['id']])['cnt'];
    ?>
        <tr>
            <td><strong><?= sanitize($cat['name']) ?></strong></td>
            <td style="color:var(--gray); font-size:0.85rem;"><?= sanitize(substr($cat['description'] ?? '', 0, 60)) ?></td>
            <td><?= $sc ?></td>
            <td><?= $pc ?></td>
            <td><?= $cat['sort_order'] ?></td>
            <td class="actions">
                <a href="categories.php?action=edit&id=<?= $cat['id'] ?>" class="btn btn-outline btn-small">Edit</a>
                <a href="categories.php?action=delete&id=<?= $cat['id'] ?>" class="btn btn-danger btn-small" onclick="return confirm('Delete this category and all its subcategories/products?')">Delete</a>
            </td>
        </tr>
    <?php endforeach; ?>
    </tbody>
</table>
<?php endif; ?>
<?php endif; ?>

<?php adminFooter(); ?>
