<?php
session_start();
if (!file_exists(__DIR__ . '/../../config.php')) {
    header('Location: ../install.php');
    exit;
}
require_once __DIR__ . '/../../includes/functions.php';
requireLogin();

$currentPage = basename($_SERVER['PHP_SELF'], '.php');

function adminHeader($title = 'Dashboard') {
    global $currentPage;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($title) ?> - RIG&amp;DIG Admin</title>
    <link rel="stylesheet" href="../assets/css/admin.css">
</head>
<body>
    <div class="admin-layout">
        <aside class="sidebar">
            <div class="brand">
                <h2>RIG&amp;DIG</h2>
                <small>Admin Panel</small>
            </div>
            <nav>
                <a href="index.php" class="<?= $currentPage === 'index' ? 'active' : '' ?>">Dashboard</a>
                <a href="categories.php" class="<?= $currentPage === 'categories' ? 'active' : '' ?>">Categories</a>
                <a href="subcategories.php" class="<?= $currentPage === 'subcategories' ? 'active' : '' ?>">Subcategories</a>
                <a href="products.php" class="<?= $currentPage === 'products' ? 'active' : '' ?>">Products</a>
            </nav>
            <div class="sidebar-footer">
                <a href="../index.php" style="font-size:0.8rem; color:var(--gray);">View Site</a>
                <a href="logout.php" style="font-size:0.8rem; color:#cc3333; float:right;">Logout</a>
            </div>
        </aside>
        <main class="main-content">
<?php
}

function adminFooter() {
?>
        </main>
    </div>
</body>
</html>
<?php
}
