<?php
require_once 'includes/layout.php';

$catCount = fetchOne("SELECT COUNT(*) as cnt FROM categories")['cnt'];
$subCount = fetchOne("SELECT COUNT(*) as cnt FROM subcategories")['cnt'];
$prodCount = fetchOne("SELECT COUNT(*) as cnt FROM products")['cnt'];
$imgCount = fetchOne("SELECT COUNT(*) as cnt FROM product_images")['cnt'];

adminHeader('Dashboard');
?>

<div class="page-header">
    <h2>Dashboard</h2>
</div>

<div class="stat-cards">
    <div class="stat-card">
        <div class="label">Categories</div>
        <div class="value"><?= $catCount ?></div>
    </div>
    <div class="stat-card">
        <div class="label">Subcategories</div>
        <div class="value"><?= $subCount ?></div>
    </div>
    <div class="stat-card">
        <div class="label">Products</div>
        <div class="value"><?= $prodCount ?></div>
    </div>
    <div class="stat-card">
        <div class="label">Images</div>
        <div class="value"><?= $imgCount ?></div>
    </div>
</div>

<div class="page-header">
    <h2>Quick Actions</h2>
</div>

<div style="display:flex; gap:15px; flex-wrap:wrap;">
    <a href="categories.php?action=add" class="btn">Add Category</a>
    <a href="subcategories.php?action=add" class="btn btn-outline">Add Subcategory</a>
    <a href="products.php?action=add" class="btn btn-outline">Add Product</a>
</div>

<?php adminFooter(); ?>
