<?php
require_once 'includes/layout.php';

$action = $_GET['action'] ?? 'list';
$id = intval($_GET['id'] ?? 0);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($action === 'delete_image') {
        $imgId = intval($_POST['image_id'] ?? 0);
        $img = fetchOne("SELECT * FROM product_images WHERE id = ?", [$imgId]);
        if ($img) {
            deleteImage($img['image_path']);
            delete('product_images', 'id = ?', [$imgId]);
            flash('success', 'Image removed.');
        }
        redirect('products.php?action=edit&id=' . intval($_POST['product_id'] ?? 0));
    }

    $name = trim($_POST['name'] ?? '');
    $subcategoryId = intval($_POST['subcategory_id'] ?? 0);
    $referenceCode = trim($_POST['reference_code'] ?? '');
    $description = trim($_POST['description'] ?? '');
    $specifications = trim($_POST['specifications'] ?? '');
    $sortOrder = intval($_POST['sort_order'] ?? 0);

    if (empty($name) || !$subcategoryId) {
        flash('error', 'Name and subcategory are required.');
    } else {
        $data = [
            'name' => $name,
            'subcategory_id' => $subcategoryId,
            'reference_code' => $referenceCode,
            'description' => $description,
            'specifications' => $specifications,
            'sort_order' => $sortOrder,
        ];

        if ($action === 'edit' && $id) {
            update('products', $data, 'id = :wid', ['wid' => $id]);
            $productId = $id;
            flash('success', 'Product updated.');
        } else {
            $productId = insert('products', $data);
            flash('success', 'Product created.');
        }

        if (!empty($_FILES['images']['name'][0])) {
            $fileCount = count($_FILES['images']['name']);
            for ($i = 0; $i < $fileCount; $i++) {
                if ($_FILES['images']['error'][$i] === UPLOAD_ERR_OK) {
                    $file = [
                        'name' => $_FILES['images']['name'][$i],
                        'type' => $_FILES['images']['type'][$i],
                        'tmp_name' => $_FILES['images']['tmp_name'][$i],
                        'size' => $_FILES['images']['size'][$i],
                    ];
                    $result = uploadImage($file);
                    if (isset($result['path'])) {
                        insert('product_images', [
                            'product_id' => $productId,
                            'image_path' => $result['path'],
                            'caption' => '',
                            'sort_order' => $i,
                        ]);
                    }
                }
            }
        }

        redirect('products.php');
    }
}

if ($action === 'delete' && $id) {
    $images = getProductImages($id);
    foreach ($images as $img) {
        deleteImage($img['image_path']);
    }
    delete('products', 'id = ?', [$id]);
    flash('success', 'Product deleted.');
    redirect('products.php');
}

$editItem = null;
$editImages = [];
if ($action === 'edit' && $id) {
    $editItem = fetchOne("SELECT * FROM products WHERE id = ?", [$id]);
    if (!$editItem) { redirect('products.php'); }
    $editImages = getProductImages($id);
}

$allCategories = getCategories();
$allSubcats = getSubcategories();

adminHeader('Products');
?>

<?php if ($flashErr = flash('error')): ?>
<div class="alert alert-error"><?= htmlspecialchars($flashErr) ?></div>
<?php endif; ?>
<?php if ($flashOk = flash('success')): ?>
<div class="alert alert-success"><?= htmlspecialchars($flashOk) ?></div>
<?php endif; ?>

<?php if ($action === 'add' || $action === 'edit'): ?>
<div class="page-header">
    <h2><?= $action === 'edit' ? 'Edit' : 'Add' ?> Product</h2>
    <a href="products.php" class="btn btn-outline btn-small">Back to List</a>
</div>

<div class="form-card">
    <form method="post" enctype="multipart/form-data">
        <div class="form-group">
            <label>Subcategory *</label>
            <select name="subcategory_id" required>
                <option value="">Select subcategory...</option>
                <?php foreach ($allCategories as $c): ?>
                <optgroup label="<?= sanitize($c['name']) ?>">
                    <?php foreach ($allSubcats as $sc):
                        if ($sc['category_id'] !== $c['id']) continue;
                    ?>
                    <option value="<?= $sc['id'] ?>" <?= ($editItem['subcategory_id'] ?? '') == $sc['id'] ? 'selected' : '' ?>><?= sanitize($sc['name']) ?></option>
                    <?php endforeach; ?>
                </optgroup>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label>Product Name *</label>
            <input type="text" name="name" value="<?= htmlspecialchars($editItem['name'] ?? '') ?>" required>
        </div>
        <div class="form-group">
            <label>Reference Code</label>
            <input type="text" name="reference_code" value="<?= htmlspecialchars($editItem['reference_code'] ?? '') ?>" placeholder="e.g. API-6A-001">
        </div>
        <div class="form-group">
            <label>Description</label>
            <textarea name="description"><?= htmlspecialchars($editItem['description'] ?? '') ?></textarea>
        </div>
        <div class="form-group">
            <label>Specifications</label>
            <textarea name="specifications"><?= htmlspecialchars($editItem['specifications'] ?? '') ?></textarea>
        </div>
        <div class="form-group">
            <label>Sort Order</label>
            <input type="number" name="sort_order" value="<?= $editItem['sort_order'] ?? 0 ?>">
        </div>

        <?php if (!empty($editImages)): ?>
        <div class="form-group">
            <label>Current Images</label>
            <div class="image-preview">
                <?php foreach ($editImages as $ei): ?>
                <div class="thumb">
                    <img src="../<?= sanitize($ei['image_path']) ?>" alt="">
                    <form method="post" action="products.php?action=delete_image" style="display:inline;">
                        <input type="hidden" name="image_id" value="<?= $ei['id'] ?>">
                        <input type="hidden" name="product_id" value="<?= $editItem['id'] ?>">
                        <button type="submit" class="remove-btn" onclick="return confirm('Remove this image?')">&times;</button>
                    </form>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>

        <div class="form-group">
            <label><?= $action === 'edit' ? 'Add More Images' : 'Product Images' ?></label>
            <input type="file" name="images[]" multiple accept="image/*" style="padding:8px;">
            <small style="color:var(--gray); display:block; margin-top:5px;">JPG, PNG, GIF, WEBP. Max 5MB each. You can select multiple files.</small>
        </div>

        <button type="submit" class="btn"><?= $action === 'edit' ? 'Update' : 'Create' ?> Product</button>
    </form>
</div>

<?php else: ?>
<div class="page-header">
    <h2>Products</h2>
    <a href="products.php?action=add" class="btn">Add Product</a>
</div>

<?php
$products = getProducts();
if (empty($products)):
?>
<p style="color:var(--gray);">No products yet. Add your first product.</p>
<?php else: ?>
<table class="data-table">
    <thead>
        <tr>
            <th>Image</th>
            <th>Name</th>
            <th>Reference</th>
            <th>Category</th>
            <th>Subcategory</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
    <?php foreach ($products as $prod):
        $img = fetchOne("SELECT * FROM product_images WHERE product_id = ? ORDER BY sort_order LIMIT 1", [$prod['id']]);
    ?>
        <tr>
            <td>
                <?php if ($img): ?>
                <img src="../<?= sanitize($img['image_path']) ?>" alt="">
                <?php else: ?>
                <span style="color:#444; font-size:0.75rem;">No image</span>
                <?php endif; ?>
            </td>
            <td><strong><?= sanitize($prod['name']) ?></strong></td>
            <td style="color:var(--orange); font-size:0.85rem;"><?= sanitize($prod['reference_code']) ?></td>
            <td style="font-size:0.85rem;"><?= sanitize($prod['category_name']) ?></td>
            <td style="font-size:0.85rem;"><?= sanitize($prod['subcategory_name']) ?></td>
            <td class="actions">
                <a href="products.php?action=edit&id=<?= $prod['id'] ?>" class="btn btn-outline btn-small">Edit</a>
                <a href="products.php?action=delete&id=<?= $prod['id'] ?>" class="btn btn-danger btn-small" onclick="return confirm('Delete this product?')">Delete</a>
            </td>
        </tr>
    <?php endforeach; ?>
    </tbody>
</table>
<?php endif; ?>
<?php endif; ?>

<?php adminFooter(); ?>
