<?php
require_once 'includes/layout.php';

$action = $_GET['action'] ?? 'list';
$id = intval($_GET['id'] ?? 0);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $categoryId = intval($_POST['category_id'] ?? 0);
    $description = trim($_POST['description'] ?? '');
    $sortOrder = intval($_POST['sort_order'] ?? 0);

    $image = trim($_POST['image'] ?? '');

    if (empty($name) || !$categoryId) {
        flash('error', 'Name and category are required.');
    } else {
        $data = ['name' => $name, 'category_id' => $categoryId, 'description' => $description, 'image' => $image, 'sort_order' => $sortOrder];

        if ($action === 'edit' && $id) {
            update('subcategories', $data, 'id = :wid', ['wid' => $id]);
            flash('success', 'Subcategory updated.');
        } else {
            insert('subcategories', $data);
            flash('success', 'Subcategory created.');
        }
        redirect('subcategories.php');
    }
}

if ($action === 'delete' && $id) {
    delete('subcategories', 'id = ?', [$id]);
    flash('success', 'Subcategory deleted.');
    redirect('subcategories.php');
}

$editItem = null;
if ($action === 'edit' && $id) {
    $editItem = fetchOne("SELECT * FROM subcategories WHERE id = ?", [$id]);
    if (!$editItem) { redirect('subcategories.php'); }
}

$allCategories = getCategories();

adminHeader('Subcategories');
?>

<?php if ($flashErr = flash('error')): ?>
<div class="alert alert-error"><?= htmlspecialchars($flashErr) ?></div>
<?php endif; ?>
<?php if ($flashOk = flash('success')): ?>
<div class="alert alert-success"><?= htmlspecialchars($flashOk) ?></div>
<?php endif; ?>

<?php if ($action === 'add' || $action === 'edit'): ?>
<div class="page-header">
    <h2><?= $action === 'edit' ? 'Edit' : 'Add' ?> Subcategory</h2>
    <a href="subcategories.php" class="btn btn-outline btn-small">Back to List</a>
</div>

<div class="form-card">
    <form method="post">
        <div class="form-group">
            <label>Parent Category *</label>
            <select name="category_id" required>
                <option value="">Select category...</option>
                <?php foreach ($allCategories as $c): ?>
                <option value="<?= $c['id'] ?>" <?= ($editItem['category_id'] ?? '') == $c['id'] ? 'selected' : '' ?>><?= sanitize($c['name']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label>Subcategory Name *</label>
            <input type="text" name="name" value="<?= htmlspecialchars($editItem['name'] ?? '') ?>" required>
        </div>
        <div class="form-group">
            <label>Description</label>
            <textarea name="description"><?= htmlspecialchars($editItem['description'] ?? '') ?></textarea>
        </div>
        <div class="form-group">
            <label>Reference Image Path</label>
            <input type="text" name="image" value="<?= htmlspecialchars($editItem['image'] ?? '') ?>" placeholder="e.g. assets/images/rigging-shackles.png">
            <small style="color:#666;">Path to the subcategory reference image (used as fallback for products without their own image)</small>
        </div>
        <div class="form-group">
            <label>Sort Order</label>
            <input type="number" name="sort_order" value="<?= $editItem['sort_order'] ?? 0 ?>">
        </div>
        <button type="submit" class="btn"><?= $action === 'edit' ? 'Update' : 'Create' ?> Subcategory</button>
    </form>
</div>

<?php else: ?>
<div class="page-header">
    <h2>Subcategories</h2>
    <a href="subcategories.php?action=add" class="btn">Add Subcategory</a>
</div>

<?php
$subcats = getSubcategories();
if (empty($subcats)):
?>
<p style="color:var(--gray);">No subcategories yet. Add your first subcategory.</p>
<?php else: ?>
<table class="data-table">
    <thead>
        <tr>
            <th>Name</th>
            <th>Category</th>
            <th>Products</th>
            <th>Order</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
    <?php foreach ($subcats as $sc):
        $pc = fetchOne("SELECT COUNT(*) as cnt FROM products WHERE subcategory_id = ?", [$sc['id']])['cnt'];
    ?>
        <tr>
            <td><strong><?= sanitize($sc['name']) ?></strong></td>
            <td style="color:var(--orange);"><?= sanitize($sc['category_name']) ?></td>
            <td><?= $pc ?></td>
            <td><?= $sc['sort_order'] ?></td>
            <td class="actions">
                <a href="subcategories.php?action=edit&id=<?= $sc['id'] ?>" class="btn btn-outline btn-small">Edit</a>
                <a href="subcategories.php?action=delete&id=<?= $sc['id'] ?>" class="btn btn-danger btn-small" onclick="return confirm('Delete this subcategory and all its products?')">Delete</a>
            </td>
        </tr>
    <?php endforeach; ?>
    </tbody>
</table>
<?php endif; ?>
<?php endif; ?>

<?php adminFooter(); ?>
