<?php
define('PAGE_LOADED', true);
session_start();
require_once 'includes/functions.php';

$pageTitle = 'Products';
$categories = getCategories();

include 'includes/header.php';
?>

<div class="container">
    <div class="breadcrumb">
        <a href="<?= SITE_URL ?>/">Home</a> <span>/</span> Products
    </div>
</div>

<section class="section" style="padding-top:20px;">
    <div class="container">
        <div class="section-header">
            <h2>Product Categories</h2>
            <p>Browse our complete range of industrial parts and equipment.</p>
        </div>
        <div class="category-grid">
            <?php foreach ($categories as $cat):
                $subcats = getSubcategories($cat['id']);
                $prodCount = fetchOne("SELECT COUNT(*) as cnt FROM products p JOIN subcategories s ON p.subcategory_id = s.id WHERE s.category_id = ?", [$cat['id']])['cnt'] ?? 0;
            ?>
            <a href="<?= SITE_URL ?>/category.php?id=<?= $cat['id'] ?>" class="category-card" style="text-decoration:none;">
                <h3><?= sanitize($cat['name']) ?></h3>
                <p><?= sanitize($cat['description']) ?></p>
                <div class="count"><?= $prodCount ?> products &bull; <?= count($subcats) ?> subcategories</div>
                <?php if (!empty($subcats)): ?>
                <div style="margin-top:12px; font-size:0.8rem; color:#666;">
                    <?= implode(' &bull; ', array_map(fn($s) => sanitize($s['name']), array_slice($subcats, 0, 4))) ?>
                    <?= count($subcats) > 4 ? ' &bull; +' . (count($subcats) - 4) . ' more' : '' ?>
                </div>
                <?php endif; ?>
            </a>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
