<?php
define('PAGE_LOADED', true);
session_start();
require_once 'includes/functions.php';

$catId = intval($_GET['id'] ?? 0);
if (!$catId) { redirect('categories.php'); }

$category = fetchOne("SELECT * FROM categories WHERE id = ?", [$catId]);
if (!$category) { redirect('categories.php'); }

$pageTitle = $category['name'];
$subcats = getSubcategories($catId);
$products = getProducts(null, $catId);

include 'includes/header.php';
?>

<div class="container">
    <div class="breadcrumb">
        <a href="<?= SITE_URL ?>/">Home</a>
        <span>/</span>
        <a href="<?= SITE_URL ?>/categories.php">Products</a>
        <span>/</span>
        <?= sanitize($category['name']) ?>
    </div>
</div>

<section class="section" style="padding-top:20px;">
    <div class="container">
        <div class="section-header">
            <h2><?= sanitize($category['name']) ?></h2>
            <p><?= sanitize($category['description']) ?></p>
        </div>

        <?php if (!empty($subcats)): ?>
        <div style="margin-bottom:30px; display:flex; gap:10px; flex-wrap:wrap; justify-content:center;">
            <?php foreach ($subcats as $sc): ?>
            <a href="<?= SITE_URL ?>/subcategory.php?id=<?= $sc['id'] ?>" class="btn btn-outline" style="font-size:0.8rem; padding:8px 18px;"><?= sanitize($sc['name']) ?></a>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>

        <?php if (empty($products)): ?>
        <div style="text-align:center; padding:40px; color:#666;">
            <p>No products added yet. Check back soon.</p>
        </div>
        <?php else: ?>
        <div class="product-grid">
            <?php foreach ($products as $prod):
                $img = fetchOne("SELECT * FROM product_images WHERE product_id = ? ORDER BY sort_order LIMIT 1", [$prod['id']]);
                $subImg = '';
                if (!$img) {
                    $subData = fetchOne("SELECT image FROM subcategories WHERE id = ?", [$prod['subcategory_id']]);
                    if ($subData && !empty($subData['image']) && file_exists(__DIR__ . '/' . $subData['image'])) {
                        $subImg = $subData['image'];
                    }
                }
            ?>
            <a href="<?= SITE_URL ?>/product.php?id=<?= $prod['id'] ?>" class="product-card" style="text-decoration:none;">
                <div class="product-image">
                    <?php if ($img): ?>
                    <img src="<?= SITE_URL ?>/<?= sanitize($img['image_path']) ?>" alt="<?= sanitize($prod['name']) ?>">
                    <?php elseif ($subImg): ?>
                    <img src="<?= SITE_URL ?>/<?= sanitize($subImg) ?>" alt="<?= sanitize($prod['name']) ?>" style="opacity:0.85;">
                    <?php else: ?>
                    <div class="no-image">No Image</div>
                    <?php endif; ?>
                </div>
                <div class="product-info">
                    <h4><?= sanitize($prod['name']) ?></h4>
                    <?php if ($prod['reference_code']): ?>
                    <div class="ref">Ref: <?= sanitize($prod['reference_code']) ?></div>
                    <?php endif; ?>
                    <p style="font-size:0.75rem; color:#666;"><?= sanitize($prod['subcategory_name']) ?></p>
                </div>
            </a>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
