<?php
error_reporting(E_ALL);
ini_set('display_errors', 0);

if (!file_exists(__DIR__ . '/../config.php')) {
    header('Location: install.php');
    exit;
}
require_once __DIR__ . '/../config.php';

if (!defined('SITE_URL') || SITE_URL === '' || SITE_URL === 'http://localhost/rigndig') {
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
    $scriptDir = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\');
    if (!defined('SITE_URL')) {
        define('SITE_URL', $protocol . '://' . $host . $scriptDir);
    }
}

function getDB() {
    static $pdo = null;
    if ($pdo === null) {
        try {
            $pdo = new PDO(
                'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=utf8mb4',
                DB_USER,
                DB_PASS,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false,
                ]
            );
        } catch (PDOException $e) {
            die('Database connection failed: ' . $e->getMessage());
        }
    }
    return $pdo;
}

function query($sql, $params = []) {
    $stmt = getDB()->prepare($sql);
    $stmt->execute($params);
    return $stmt;
}

function fetchAll($sql, $params = []) {
    return query($sql, $params)->fetchAll();
}

function fetchOne($sql, $params = []) {
    return query($sql, $params)->fetch();
}

function insert($table, $data) {
    $keys = array_keys($data);
    $placeholders = array_map(fn($k) => ':' . $k, $keys);
    $sql = "INSERT INTO $table (" . implode(',', $keys) . ") VALUES (" . implode(',', $placeholders) . ")";
    query($sql, $data);
    return getDB()->lastInsertId();
}

function update($table, $data, $where, $whereParams = []) {
    $sets = array_map(fn($k) => "$k = :$k", array_keys($data));
    $sql = "UPDATE $table SET " . implode(',', $sets) . " WHERE $where";
    query($sql, array_merge($data, $whereParams));
}

function delete($table, $where, $params = []) {
    query("DELETE FROM $table WHERE $where", $params);
}
