<?php if (!defined('PAGE_LOADED')) { die('Direct access not allowed.'); } ?>
    <footer class="site-footer">
        <div class="container">
            <div class="footer-grid">
                <div class="footer-col">
                    <h4>RIG&amp;DIG</h4>
                    <p>Industrial parts supplier based in Islamabad, Pakistan. We import and manufacture parts for rigging, mining, and oil &amp; gas industries—supplied on demand.</p>
                </div>
                <div class="footer-col">
                    <h4>Our Products</h4>
                    <?php
                    try {
                        $footerCats = getCategories();
                        foreach ($footerCats as $fc):
                    ?>
                    <a href="<?= SITE_URL ?>/category.php?id=<?= $fc['id'] ?>"><?= sanitize($fc['name']) ?></a>
                    <?php
                        endforeach;
                    } catch (Exception $e) {
                        echo '<a href="' . SITE_URL . '/categories.php">View All Products</a>';
                    }
                    ?>
                </div>
                <div class="footer-col">
                    <h4>Contact</h4>
                    <p>Islamabad, Pakistan</p>
                    <a href="tel:+923332594493">+92 333 259 4493</a>
                    <a href="mailto:Info@rigndig.com">Info@rigndig.com</a>
                    <a href="https://wa.me/923332594493" target="_blank">WhatsApp</a>
                </div>
            </div>
            <div class="footer-bottom">
                &copy; <?= date('Y') ?> RIG&amp;DIG Industrial Suppliers. All rights reserved.
            </div>
        </div>
    </footer>

    <div class="lightbox" id="lightbox" onclick="closeLightbox()">
        <button class="lightbox-close" onclick="closeLightbox()">&times;</button>
        <img id="lightbox-img" src="" alt="">
    </div>

    <script>
    function openLightbox(src) {
        document.getElementById('lightbox-img').src = src;
        document.getElementById('lightbox').classList.add('active');
    }
    function closeLightbox() {
        document.getElementById('lightbox').classList.remove('active');
    }
    </script>
</body>
</html>
