<?php if (!defined('PAGE_LOADED')) { die('Direct access not allowed.'); } ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= isset($pageTitle) ? sanitize($pageTitle) . ' - ' : '' ?>RIG&amp;DIG Industrial Suppliers</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Oxanium:wght@400;600;700;800&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?= SITE_URL ?>/assets/css/style.css">
    <link rel="icon" href="<?= SITE_URL ?>/assets/images/rigndig-logo.png" type="image/png">
</head>
<body>
    <header class="site-header">
        <div class="container">
            <div class="header-inner">
                <a href="<?= SITE_URL ?>/" class="brand" style="text-decoration:none;">
                    <h1>RIG&amp;DIG</h1>
                    <div class="tagline">INDUSTRIAL SUPPLIERS &bull; RIGGING &bull; MINING</div>
                </a>
                <nav class="nav-links">
                    <a href="<?= SITE_URL ?>/">Home</a>
                    <a href="<?= SITE_URL ?>/categories.php">Products</a>
                    <a href="<?= SITE_URL ?>/contact.php">Contact</a>
                </nav>
                <div class="contact-bar">
                    <a href="tel:+923332594493">+92 333 259 4493</a>
                    <a href="mailto:Info@rigndig.com">Info@rigndig.com</a>
                    <a href="https://wa.me/923332594493" class="whatsapp-btn" target="_blank">WhatsApp</a>
                </div>
            </div>
        </div>
    </header>
