<?php
define('PAGE_LOADED', true);
session_start();
require_once 'includes/functions.php';

try {
    $categories = getCategories();
    $totalProducts = fetchOne("SELECT COUNT(*) as cnt FROM products")['cnt'] ?? 0;
    $totalSubcats = fetchOne("SELECT COUNT(*) as cnt FROM subcategories")['cnt'] ?? 0;
} catch (Exception $e) {
    $categories = [];
    $totalProducts = 0;
    $totalSubcats = 0;
}

include 'includes/header.php';
?>

<section class="hero">
    <div class="container">
        <h2>Parts that hold the load.<br><span>Built for the field.</span></h2>
        <p>RIG&amp;DIG Industrial Suppliers provides imported and locally manufactured parts for rigging, mining, and oil &amp; gas industries—supplied on demand with practical guidance, dependable fitment, and fast turnaround.</p>
        <a href="<?= SITE_URL ?>/categories.php" class="btn">View Products</a>
        <a href="mailto:Info@rigndig.com" class="btn btn-outline" style="margin-left:10px;">Request a Quote</a>
    </div>
</section>

<div class="container">
    <div class="stats-row">
        <div class="stat-item">
            <div class="stat-label">Categories</div>
            <div class="stat-value"><?= count($categories) ?></div>
        </div>
        <div class="stat-item">
            <div class="stat-label">Lead Time</div>
            <div class="stat-value">Fast</div>
        </div>
        <div class="stat-item">
            <div class="stat-label">Quality</div>
            <div class="stat-value">Field-Ready</div>
        </div>
        <div class="stat-item">
            <div class="stat-label">Support</div>
            <div class="stat-value">Responsive</div>
        </div>
    </div>
</div>

<section class="section">
    <div class="container">
        <div class="section-header">
            <h2>What We Provide</h2>
            <p>Imported or manufactured—supplied on demand.</p>
        </div>
        <div class="category-grid">
            <?php foreach ($categories as $cat):
                $subcatCount = fetchOne("SELECT COUNT(*) as cnt FROM subcategories WHERE category_id = ?", [$cat['id']])['cnt'] ?? 0;
                $prodCount = fetchOne("SELECT COUNT(*) as cnt FROM products p JOIN subcategories s ON p.subcategory_id = s.id WHERE s.category_id = ?", [$cat['id']])['cnt'] ?? 0;
                $catImg = fetchOne("SELECT image FROM subcategories WHERE category_id = ? AND image IS NOT NULL AND image != '' ORDER BY sort_order LIMIT 1", [$cat['id']]);
                $imgPath = ($catImg && !empty($catImg['image'])) ? $catImg['image'] : '';
            ?>
            <a href="<?= SITE_URL ?>/category.php?id=<?= $cat['id'] ?>" class="category-card" style="text-decoration:none;">
                <?php if ($imgPath && file_exists(dirname(__FILE__) . '/' . $imgPath)): ?>
                <div style="margin-bottom:12px; border-radius:8px; overflow:hidden; height:160px;">
                    <img src="<?= SITE_URL ?>/<?= sanitize($imgPath) ?>" alt="<?= sanitize($cat['name']) ?>" style="width:100%; height:100%; object-fit:cover;">
                </div>
                <?php endif; ?>
                <h3><?= sanitize($cat['name']) ?></h3>
                <p><?= sanitize($cat['description']) ?></p>
                <div class="count"><?= $prodCount ?> products &bull; <?= $subcatCount ?> subcategories</div>
            </a>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<section class="section" style="border-top: 1px solid #1a1a1a;">
    <div class="container">
        <div class="section-header">
            <h2>Our Promise</h2>
            <p>Correct fitment and dependable quality</p>
        </div>
        <div class="promise-grid">
            <div class="promise-item">
                <h4>Clear Communication</h4>
                <p>Direct points of contact with transparent timelines and honest guidance on part selection.</p>
            </div>
            <div class="promise-item">
                <h4>Correct Fitment</h4>
                <p>We verify specifications before dispatch so parts arrive field-ready with no surprises.</p>
            </div>
            <div class="promise-item">
                <h4>Quality Control</h4>
                <p>Every part is inspected and verified against industry standards before shipping.</p>
            </div>
            <div class="promise-item">
                <h4>On-Demand Supply</h4>
                <p>We import or manufacture to your specifications—no overstock, no compromises.</p>
            </div>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
