<?php
session_start();

if (file_exists('config.php')) {
    header('Location: index.php');
    exit;
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $host = trim($_POST['db_host'] ?? 'localhost');
    $name = trim($_POST['db_name'] ?? '');
    $user = trim($_POST['db_user'] ?? '');
    $pass = $_POST['db_pass'] ?? '';
    $siteUrl = rtrim(trim($_POST['site_url'] ?? ''), '/');
    $adminUser = trim($_POST['admin_user'] ?? 'admin');
    $adminPass = $_POST['admin_pass'] ?? '';

    if (empty($name) || empty($user) || empty($adminUser) || empty($adminPass)) {
        $error = 'Please fill in all required fields.';
    } else {
        try {
            $pdo = new PDO("mysql:host=$host;charset=utf8mb4", $user, $pass, [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            ]);

            $pdo->exec("CREATE DATABASE IF NOT EXISTS `$name` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
            $pdo->exec("USE `$name`");

            $schema = "
            CREATE TABLE IF NOT EXISTS categories (
                id INT AUTO_INCREMENT PRIMARY KEY,
                name VARCHAR(255) NOT NULL,
                description TEXT,
                icon VARCHAR(100) DEFAULT '',
                sort_order INT DEFAULT 0,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            ) ENGINE=InnoDB;

            CREATE TABLE IF NOT EXISTS subcategories (
                id INT AUTO_INCREMENT PRIMARY KEY,
                category_id INT NOT NULL,
                name VARCHAR(255) NOT NULL,
                description TEXT,
                image VARCHAR(500) DEFAULT '',
                sort_order INT DEFAULT 0,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                FOREIGN KEY (category_id) REFERENCES categories(id) ON DELETE CASCADE
            ) ENGINE=InnoDB;

            CREATE TABLE IF NOT EXISTS products (
                id INT AUTO_INCREMENT PRIMARY KEY,
                subcategory_id INT NOT NULL,
                name VARCHAR(255) NOT NULL,
                reference_code VARCHAR(100) DEFAULT '',
                description TEXT,
                specifications TEXT,
                sort_order INT DEFAULT 0,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                FOREIGN KEY (subcategory_id) REFERENCES subcategories(id) ON DELETE CASCADE
            ) ENGINE=InnoDB;

            CREATE TABLE IF NOT EXISTS product_images (
                id INT AUTO_INCREMENT PRIMARY KEY,
                product_id INT NOT NULL,
                image_path VARCHAR(500) NOT NULL,
                caption VARCHAR(255) DEFAULT '',
                sort_order INT DEFAULT 0,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                FOREIGN KEY (product_id) REFERENCES products(id) ON DELETE CASCADE
            ) ENGINE=InnoDB;
            ";

            $statements = array_filter(array_map('trim', explode(';', $schema)));
            foreach ($statements as $stmt) {
                if (!empty($stmt)) {
                    $pdo->exec($stmt);
                }
            }

            $checkCat = $pdo->query("SELECT COUNT(*) FROM categories")->fetchColumn();
            if ($checkCat == 0) {
                $demoData = [
                    [
                        'name' => 'Rigging Parts',
                        'description' => 'Imported & locally manufactured lifting and rigging hardware for safe, rated operations',
                        'sort_order' => 1,
                        'subs' => [
                            ['Shackles', 'Bow, D-type, wide body and chain shackles', 'assets/images/rigging-shackles.png', [
                                ['Bow Shackle (Bolt Type)', 'RIG-SH-001', 'WLL 2T–150T, Alloy Steel, Grade 80'],
                                ['D-Shackle (Screw Pin)', 'RIG-SH-002', 'WLL 0.5T–55T, Drop Forged'],
                                ['Wide Body Shackle', 'RIG-SH-003', 'WLL 25T–300T, High Tensile'],
                                ['Chain Shackle (Dee Type)', 'RIG-SH-004', 'WLL 1T–85T, Hot Dip Galvanized'],
                            ]],
                            ['Wire Rope & Slings', 'Steel wire rope, webbing and round slings', 'assets/images/rigging-slings.png', [
                                ['Steel Wire Rope 6x19', 'RIG-WR-001', '8mm–52mm, IWRC, Galvanized'],
                                ['Steel Wire Rope 6x36', 'RIG-WR-002', '10mm–64mm, Fiber Core / IWRC'],
                                ['Wire Rope Sling (Single Leg)', 'RIG-SL-001', 'WLL 1T–50T, Flemish Eye'],
                                ['Wire Rope Sling (Multi-Leg)', 'RIG-SL-002', '2-Leg / 4-Leg, WLL 2T–100T'],
                                ['Webbing Sling (Flat)', 'RIG-SL-003', '1T–10T, Polyester, Color Coded'],
                                ['Round Sling (Endless)', 'RIG-SL-004', '1T–30T, High Tenacity Polyester'],
                            ]],
                            ['Hooks & Pins', 'Grab hooks, eye hooks, swivel hooks and anchor pins', 'assets/images/rigging-hooks.png', [
                                ['Clevis Grab Hook', 'RIG-HK-001', 'Grade 80, WLL 1.1T–31.5T'],
                                ['Eye Hook with Latch', 'RIG-HK-002', 'WLL 1T–15T, Forged Alloy Steel'],
                                ['Swivel Hook (Self-Locking)', 'RIG-HK-003', 'WLL 1T–35T, 360 Rotation'],
                                ['Anchor Pin / Bolt Pin', 'RIG-PN-001', 'Dia 16mm–100mm, High Tensile'],
                                ['Lynch Pin / Cotter Pin', 'RIG-PN-002', 'Zinc Plated, Assorted Sizes'],
                            ]],
                            ['Turnbuckles & Rigging Screws', 'Jaw-jaw, eye-eye turnbuckles and bottle screws', 'assets/images/rigging-turnbuckles.png', [
                                ['Turnbuckle (Jaw-Jaw)', 'RIG-TB-001', 'M10–M36, Drop Forged, Galv.'],
                                ['Turnbuckle (Eye-Eye)', 'RIG-TB-002', 'M10–M36, Stainless / Carbon'],
                                ['Rigging Screw (Bottle Type)', 'RIG-TB-003', 'M12–M48, Closed Body'],
                            ]],
                            ['Chain & Fittings', 'Load chains, master links, connecting links and swivels', 'assets/images/rigging-chain.png', [
                                ['Load Chain Grade 80', 'RIG-CH-001', '6mm–32mm, Alloy Steel, EN 818'],
                                ['Load Chain Grade 100', 'RIG-CH-002', '6mm–22mm, High Performance'],
                                ['Master Link (Oblong)', 'RIG-ML-001', 'WLL 1.5T–125T, Forged'],
                                ['Connecting Link', 'RIG-CL-001', '6mm–22mm, Grade 80'],
                                ['Swivel (Jaw-Eye)', 'RIG-SW-001', 'WLL 1T–25T, Forged Alloy'],
                            ]],
                        ],
                    ],
                    [
                        'name' => 'Mining Parts',
                        'description' => 'Wear parts, safety equipment, and spares for mining operations and heavy machinery',
                        'sort_order' => 2,
                        'subs' => [
                            ['Crusher Wear Parts', 'Jaw plates, mantles, concaves and blow bars', 'assets/images/mining-crusher.png', [
                                ['Jaw Crusher Plate (Fixed)', 'MIN-CW-001', 'Mn13Cr2 / Mn18Cr2, Custom Sizes'],
                                ['Jaw Crusher Plate (Movable)', 'MIN-CW-002', 'High Manganese Steel, Heat Treated'],
                                ['Cone Crusher Mantle', 'MIN-CW-003', 'Mn13–Mn18, Standard / Short Head'],
                                ['Cone Crusher Concave', 'MIN-CW-004', 'Mn13–Mn18, Segmented'],
                                ['Impact Crusher Blow Bar', 'MIN-CW-005', 'High Chrome / Martensitic Steel'],
                            ]],
                            ['Screen & Conveyor Parts', 'Vibrating screens, conveyor belts and idlers', 'assets/images/mining-screen.png', [
                                ['Vibrating Screen Mesh', 'MIN-SC-001', 'Woven Wire, PU Coated, 2mm–80mm'],
                                ['Polyurethane Screen Panel', 'MIN-SC-002', 'Modular, Tensioned, Custom Aperture'],
                                ['Conveyor Belt (Multi-Ply)', 'MIN-CB-001', 'EP100–EP500, 500mm–1800mm Width'],
                                ['Conveyor Idler Roller', 'MIN-CB-002', 'Dia 89mm–159mm, Sealed Bearing'],
                                ['Conveyor Belt Scraper', 'MIN-CB-003', 'Primary / Secondary, Tungsten Tip'],
                            ]],
                            ['Ground Engaging Tools (GET)', 'Bucket teeth, adapters, cutting edges and ripper teeth', 'assets/images/mining-get.png', [
                                ['Excavator Bucket Teeth', 'MIN-GT-001', 'CAT / Komatsu / Hitachi Compatible'],
                                ['Bucket Tooth Adapter', 'MIN-GT-002', 'Weld-On / Pin-On, Various Models'],
                                ['Loader Cutting Edge', 'MIN-GT-003', 'Bolt-On, Heat Treated Steel'],
                                ['Ripper Tooth / Shank', 'MIN-GT-004', 'D6–D11, Single / Multi-Shank'],
                            ]],
                            ['Safety & PPE', 'Hard hats, harnesses, respirators and safety boots', 'assets/images/mining-safety.png', [
                                ['Mining Hard Hat (Vented)', 'MIN-SF-001', 'ANSI Z89.1, Class E, with Lamp Bracket'],
                                ['Safety Harness (Full Body)', 'MIN-SF-002', 'EN 361, 5-Point, with Shock Absorber'],
                                ['Dust Respirator (P2/P3)', 'MIN-SF-003', 'Half-Face / Full-Face, Replaceable Filter'],
                                ['Mining Boots (Steel Toe)', 'MIN-SF-004', 'S3 HRO SRC, Metatarsal Guard'],
                            ]],
                        ],
                    ],
                    [
                        'name' => 'Oil & Gas Equipment',
                        'description' => 'API-standard flanges, fittings, pipes and wellhead components for upstream and midstream',
                        'sort_order' => 3,
                        'subs' => [
                            ['API 6A Flanges', 'Weld neck, blind, slip-on, socket weld and wellhead flanges', 'assets/images/oilgas-flanges.png', [
                                ['Weld Neck Flange (WNRF)', 'OG-FL-001', '2"–24", Class 150–2500, ASME B16.5'],
                                ['Blind Flange', 'OG-FL-002', '2"–24", Class 150–2500, RF/RTJ'],
                                ['Slip-On Flange', 'OG-FL-003', '2"–24", Class 150–600, Raised Face'],
                                ['Socket Weld Flange', 'OG-FL-004', '1/2"–4", Class 150–1500'],
                                ['Threaded Flange', 'OG-FL-005', '1/2"–4", Class 150–1500, NPT'],
                                ['API 6A Flange (Wellhead)', 'OG-FL-006', '2 1/16"–7 1/16", 2K–15K PSI'],
                            ]],
                            ['RTJ Ring Gaskets', 'Oval, octagonal, RX, BX and spiral wound gaskets', 'assets/images/oilgas-gaskets.png', [
                                ['RTJ Gasket (Oval)', 'OG-RG-001', 'R11–R90, SS304/316, Soft Iron'],
                                ['RTJ Gasket (Octagonal)', 'OG-RG-002', 'R11–R90, ASME B16.20'],
                                ['RX Ring Gasket', 'OG-RG-003', 'RX20–RX90, API 6A, Pressure Energized'],
                                ['BX Ring Gasket', 'OG-RG-004', 'BX150–BX168, 5K–20K PSI'],
                                ['Spiral Wound Gasket', 'OG-RG-005', '1/2"–60", SS316/Graphite, CGI'],
                            ]],
                            ['Hammer Unions & Fittings', 'Fig. 100 to 1502 hammer unions and pup joints', 'assets/images/oilgas-hammer-unions.png', [
                                ['Hammer Union (Fig. 100)', 'OG-HU-001', '1"–4", 1000 PSI CWP, Standard'],
                                ['Hammer Union (Fig. 206)', 'OG-HU-002', '2"–4", 2000 PSI CWP'],
                                ['Hammer Union (Fig. 602)', 'OG-HU-003', '2"–4", 6000 PSI CWP'],
                                ['Hammer Union (Fig. 1002)', 'OG-HU-004', '2"–4", 10000 PSI CWP'],
                                ['Hammer Union (Fig. 1502)', 'OG-HU-005', '2"–4", 15000 PSI CWP'],
                                ['Pup Joint (Threaded/Welded)', 'OG-PJ-001', '2"–4", Various Lengths, SCH 80/160'],
                            ]],
                            ['Pipes & Fittings', 'Seamless and welded pipes, elbows, tees and reducers', 'assets/images/oilgas-pipes.png', [
                                ['Seamless Steel Pipe', 'OG-PP-001', '2"–24", API 5L, Grade B–X65'],
                                ['Welded Steel Pipe (ERW)', 'OG-PP-002', '2"–20", ASTM A53 / API 5L'],
                                ['Pipe Elbow (90/45 deg)', 'OG-PF-001', '1/2"–24", SCH 40/80/160, BW'],
                                ['Pipe Tee (Equal/Reducing)', 'OG-PF-002', '1/2"–24", ASTM A234 WPB'],
                                ['Pipe Reducer (Con/Ecc)', 'OG-PF-003', '1"–24", Seamless, BW'],
                            ]],
                            ['Valves', 'Gate, ball, check and needle valves', 'assets/images/oilgas-valves.png', [
                                ['Gate Valve (API 600)', 'OG-VL-001', '2"–24", Class 150–1500, Flanged'],
                                ['Ball Valve (Floating)', 'OG-VL-002', '1/2"–6", Class 150–600, Full Bore'],
                                ['Check Valve (Swing Type)', 'OG-VL-003', '2"–24", Class 150–1500'],
                                ['Needle Valve', 'OG-VL-004', '1/4"–1", 6000 PSI, SS316'],
                            ]],
                        ],
                    ],
                    [
                        'name' => 'Explosion-Proof Electrical',
                        'description' => 'ATEX/IECEx certified lighting, cables, switches and junction boxes for hazardous areas',
                        'sort_order' => 4,
                        'subs' => [
                            ['Explosion-Proof Lights', 'LED floodlights, highbays, bulkheads and torches', 'assets/images/exproof-lights.png', [
                                ['Ex-Proof LED Floodlight', 'EP-LT-001', '50W–400W, Zone 1/2, ATEX, IP66'],
                                ['Ex-Proof LED Highbay', 'EP-LT-002', '100W–300W, Zone 1/21, IECEx'],
                                ['Ex-Proof Bulkhead Light', 'EP-LT-003', '20W–60W, Zone 1/2, Marine Grade'],
                                ['Ex-Proof Portable Torch', 'EP-LT-004', 'Rechargeable, Zone 0/1, ATEX'],
                                ['Ex-Proof Emergency Light', 'EP-LT-005', 'LED, 3hr Backup, Zone 1/2'],
                            ]],
                            ['Cables & Glands', 'Armoured cables, fire resistant cables and cable glands', 'assets/images/exproof-cables.png', [
                                ['Armoured Cable (SWA)', 'EP-CB-001', '1.5mm2–240mm2, 2/3/4 Core, XLPE'],
                                ['Fire Resistant Cable', 'EP-CB-002', 'IEC 60331, 2-Core/4-Core, LSZH'],
                                ['Ex-Proof Cable Gland', 'EP-CG-001', 'M20–M75, Nickel Plated Brass, ATEX'],
                                ['Cable Gland (Barrier Type)', 'EP-CG-002', 'M20–M63, Zone 0/1, Flameproof'],
                                ['Flexible Conduit (Ex-Proof)', 'EP-CD-001', '3/4"–2", SS Braided, Liquid-Tight'],
                            ]],
                            ['Switches & Controls', 'Control stations, isolators, push buttons and limit switches', 'assets/images/exproof-switches.png', [
                                ['Ex-Proof Control Station', 'EP-SW-001', '1–6 Button, Zone 1/2, GRP/Aluminium'],
                                ['Ex-Proof Isolator Switch', 'EP-SW-002', '25A–250A, 3/4 Pole, ATEX'],
                                ['Ex-Proof Push Button', 'EP-SW-003', '1NO/1NC, Momentary/Latching, LED'],
                                ['Ex-Proof Limit Switch', 'EP-SW-004', 'Zone 1/2, Roller Lever, IP67'],
                            ]],
                            ['Junction Boxes & Enclosures', 'Junction boxes, terminal boxes and distribution boards', 'assets/images/exproof-junctions.png', [
                                ['Ex-Proof Junction Box', 'EP-JB-001', 'Zone 1/2, Cast Aluminium, IP66'],
                                ['Ex-Proof Terminal Box', 'EP-JB-002', '4–24 Terminals, Flameproof, ATEX'],
                                ['Ex-Proof Distribution Board', 'EP-DB-001', 'MCB/MCCB, Zone 1/2, Custom Config'],
                                ['Instrument Enclosure (Ex-d)', 'EP-EN-001', 'SS316/GRP, Zone 1, Hinged Cover'],
                            ]],
                        ],
                    ],
                ];

                $insertCat = $pdo->prepare("INSERT INTO categories (name, description, sort_order) VALUES (?, ?, ?)");
                $insertSub = $pdo->prepare("INSERT INTO subcategories (category_id, name, description, image, sort_order) VALUES (?, ?, ?, ?, ?)");
                $insertProd = $pdo->prepare("INSERT INTO products (subcategory_id, name, reference_code, specifications, sort_order) VALUES (?, ?, ?, ?, ?)");

                foreach ($demoData as $cat) {
                    $insertCat->execute([$cat['name'], $cat['description'], $cat['sort_order']]);
                    $catId = $pdo->lastInsertId();
                    foreach ($cat['subs'] as $si => $sub) {
                        $insertSub->execute([$catId, $sub[0], $sub[1], $sub[2], $si]);
                        $subId = $pdo->lastInsertId();
                        foreach ($sub[3] as $pi => $prod) {
                            $insertProd->execute([$subId, $prod[0], $prod[1], $prod[2], $pi]);
                        }
                    }
                }
            }

            $hashedPass = password_hash($adminPass, PASSWORD_DEFAULT);
            $configContent = "<?php\n";
            $configContent .= "define('DB_HOST', " . var_export($host, true) . ");\n";
            $configContent .= "define('DB_NAME', " . var_export($name, true) . ");\n";
            $configContent .= "define('DB_USER', " . var_export($user, true) . ");\n";
            $configContent .= "define('DB_PASS', " . var_export($pass, true) . ");\n";
            $configContent .= "define('SITE_URL', " . var_export($siteUrl, true) . ");\n";
            $configContent .= "define('ADMIN_USER', " . var_export($adminUser, true) . ");\n";
            $configContent .= "define('ADMIN_PASS', " . var_export($hashedPass, true) . ");\n";

            if (file_put_contents('config.php', $configContent)) {
                $success = 'Installation complete! Redirecting to your site...';
                header('Refresh: 2; URL=index.php');
            } else {
                $error = 'Could not write config.php. Check file permissions.';
            }

        } catch (PDOException $e) {
            $error = 'Database error: ' . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Install - RIG&amp;DIG Industrial Suppliers</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            background: #000;
            color: #fff;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .installer {
            background: #111;
            border: 1px solid #333;
            border-radius: 12px;
            padding: 40px;
            max-width: 500px;
            width: 90%;
        }
        .logo {
            text-align: center;
            margin-bottom: 30px;
        }
        .logo h1 {
            font-size: 2rem;
            color: #ff6a00;
            letter-spacing: 2px;
        }
        .logo p {
            color: #888;
            font-size: 0.85rem;
            margin-top: 5px;
        }
        .form-group {
            margin-bottom: 18px;
        }
        label {
            display: block;
            color: #ccc;
            font-size: 0.85rem;
            margin-bottom: 6px;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        input {
            width: 100%;
            padding: 10px 14px;
            background: #1a1a1a;
            border: 1px solid #333;
            border-radius: 6px;
            color: #fff;
            font-size: 0.95rem;
            transition: border-color 0.2s;
        }
        input:focus {
            outline: none;
            border-color: #ff6a00;
        }
        .section-title {
            color: #ff6a00;
            font-size: 0.8rem;
            text-transform: uppercase;
            letter-spacing: 2px;
            margin: 25px 0 15px;
            padding-bottom: 8px;
            border-bottom: 1px solid #222;
        }
        button {
            width: 100%;
            padding: 14px;
            background: #ff6a00;
            color: #000;
            border: none;
            border-radius: 6px;
            font-size: 1rem;
            font-weight: 700;
            cursor: pointer;
            margin-top: 10px;
            text-transform: uppercase;
            letter-spacing: 1px;
            transition: background 0.2s;
        }
        button:hover {
            background: #ff8533;
        }
        .error {
            background: rgba(255, 50, 50, 0.15);
            border: 1px solid #ff3232;
            color: #ff6666;
            padding: 12px;
            border-radius: 6px;
            margin-bottom: 15px;
            font-size: 0.9rem;
        }
        .success {
            background: rgba(50, 255, 50, 0.15);
            border: 1px solid #32ff32;
            color: #66ff66;
            padding: 12px;
            border-radius: 6px;
            margin-bottom: 15px;
            font-size: 0.9rem;
        }
    </style>
</head>
<body>
    <div class="installer">
        <div class="logo">
            <h1>RIG&amp;DIG</h1>
            <p>INDUSTRIAL SUPPLIERS - INSTALLATION</p>
        </div>

        <?php if ($error): ?>
            <div class="error"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>
        <?php if ($success): ?>
            <div class="success"><?= htmlspecialchars($success) ?></div>
        <?php endif; ?>

        <form method="post">
            <div class="section-title">Database Settings</div>
            <div class="form-group">
                <label>Database Host *</label>
                <input type="text" name="db_host" value="<?= htmlspecialchars($_POST['db_host'] ?? 'localhost') ?>" required>
            </div>
            <div class="form-group">
                <label>Database Name *</label>
                <input type="text" name="db_name" value="<?= htmlspecialchars($_POST['db_name'] ?? 'rigndig_db') ?>" required>
            </div>
            <div class="form-group">
                <label>Database Username *</label>
                <input type="text" name="db_user" value="<?= htmlspecialchars($_POST['db_user'] ?? 'root') ?>" required>
            </div>
            <div class="form-group">
                <label>Database Password</label>
                <input type="password" name="db_pass" value="">
            </div>

            <div class="section-title">Site Settings</div>
            <div class="form-group">
                <label>Site URL *</label>
                <?php
                    $autoUrl = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' ? 'https' : 'http') . '://' . ($_SERVER['HTTP_HOST'] ?? 'localhost') . rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\');
                ?>
                <input type="text" name="site_url" value="<?= htmlspecialchars($_POST['site_url'] ?? $autoUrl) ?>" required>
                <small style="color:#888; font-size:12px;">This should be the full URL to your site folder (no trailing slash)</small>
            </div>

            <div class="section-title">Admin Account</div>
            <div class="form-group">
                <label>Admin Username *</label>
                <input type="text" name="admin_user" value="<?= htmlspecialchars($_POST['admin_user'] ?? 'admin') ?>" required>
            </div>
            <div class="form-group">
                <label>Admin Password *</label>
                <input type="password" name="admin_pass" required>
            </div>

            <button type="submit">Install RIG&amp;DIG</button>
        </form>
    </div>
</body>
</html>
