<?php
define('PAGE_LOADED', true);
session_start();
require_once 'includes/functions.php';

$prodId = intval($_GET['id'] ?? 0);
if (!$prodId) { redirect('categories.php'); }

$product = fetchOne("SELECT p.*, s.name as subcategory_name, s.id as subcategory_id, s.image as subcategory_image, c.name as category_name, c.id as category_id FROM products p JOIN subcategories s ON p.subcategory_id = s.id JOIN categories c ON s.category_id = c.id WHERE p.id = ?", [$prodId]);
if (!$product) { redirect('categories.php'); }

$pageTitle = $product['name'];
$images = getProductImages($prodId);
$fallbackImg = '';
if (empty($images) && !empty($product['subcategory_image']) && file_exists(__DIR__ . '/' . $product['subcategory_image'])) {
    $fallbackImg = $product['subcategory_image'];
}

include 'includes/header.php';
?>

<div class="container">
    <div class="breadcrumb">
        <a href="<?= SITE_URL ?>/">Home</a>
        <span>/</span>
        <a href="<?= SITE_URL ?>/categories.php">Products</a>
        <span>/</span>
        <a href="<?= SITE_URL ?>/category.php?id=<?= $product['category_id'] ?>"><?= sanitize($product['category_name']) ?></a>
        <span>/</span>
        <a href="<?= SITE_URL ?>/subcategory.php?id=<?= $product['subcategory_id'] ?>"><?= sanitize($product['subcategory_name']) ?></a>
        <span>/</span>
        <?= sanitize($product['name']) ?>
    </div>
</div>

<section class="section" style="padding-top:20px;">
    <div class="container">
        <div style="max-width:900px; margin:0 auto;">
            <h2 style="font-family:'Oxanium',sans-serif; font-size:1.8rem; margin-bottom:5px;"><?= sanitize($product['name']) ?></h2>
            <?php if ($product['reference_code']): ?>
            <div style="color:var(--orange); font-size:0.85rem; text-transform:uppercase; letter-spacing:1px; margin-bottom:20px;">Ref: <?= sanitize($product['reference_code']) ?></div>
            <?php endif; ?>

            <?php if (!empty($images)): ?>
            <div style="margin-bottom:30px;">
                <div style="border-radius:8px; overflow:hidden; margin-bottom:10px;">
                    <img src="<?= SITE_URL ?>/<?= sanitize($images[0]['image_path']) ?>" alt="<?= sanitize($product['name']) ?>" style="width:100%; max-height:500px; object-fit:contain; background:#111; cursor:pointer;" onclick="openLightbox(this.src)">
                </div>
                <?php if (count($images) > 1): ?>
                <div class="image-gallery">
                    <?php foreach ($images as $img): ?>
                    <img src="<?= SITE_URL ?>/<?= sanitize($img['image_path']) ?>" alt="<?= sanitize($img['caption'] ?: $product['name']) ?>" onclick="openLightbox(this.src)">
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>
            </div>
            <?php elseif ($fallbackImg): ?>
            <div style="margin-bottom:30px;">
                <div style="border-radius:8px; overflow:hidden;">
                    <img src="<?= SITE_URL ?>/<?= sanitize($fallbackImg) ?>" alt="<?= sanitize($product['name']) ?>" style="width:100%; max-height:500px; object-fit:contain; background:#111;">
                </div>
            </div>
            <?php endif; ?>

            <?php if ($product['description']): ?>
            <div style="margin-bottom:25px;">
                <h4 style="color:var(--orange); font-family:'Oxanium',sans-serif; font-size:0.85rem; text-transform:uppercase; letter-spacing:2px; margin-bottom:10px;">Description</h4>
                <p style="color:var(--gray); line-height:1.8;"><?= nl2br(sanitize($product['description'])) ?></p>
            </div>
            <?php endif; ?>

            <?php if ($product['specifications']): ?>
            <div style="margin-bottom:25px;">
                <h4 style="color:var(--orange); font-family:'Oxanium',sans-serif; font-size:0.85rem; text-transform:uppercase; letter-spacing:2px; margin-bottom:10px;">Specifications</h4>
                <p style="color:var(--gray); line-height:1.8;"><?= nl2br(sanitize($product['specifications'])) ?></p>
            </div>
            <?php endif; ?>

            <div style="margin-top:30px; padding-top:20px; border-top:1px solid #222;">
                <a href="mailto:Info@rigndig.com?subject=Inquiry: <?= urlencode($product['name']) ?>" class="btn">Request Quote</a>
                <a href="https://wa.me/923332594493?text=<?= urlencode('Hi, I am interested in: ' . $product['name'] . ($product['reference_code'] ? ' (Ref: ' . $product['reference_code'] . ')' : '')) ?>" class="btn btn-outline" style="margin-left:10px;" target="_blank">WhatsApp</a>
            </div>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
