<?php
define('PAGE_LOADED', true);
session_start();
require_once 'includes/functions.php';

$subId = intval($_GET['id'] ?? 0);
if (!$subId) { redirect('categories.php'); }

$subcat = fetchOne("SELECT s.*, c.name as category_name, c.id as category_id FROM subcategories s JOIN categories c ON s.category_id = c.id WHERE s.id = ?", [$subId]);
if (!$subcat) { redirect('categories.php'); }

$pageTitle = $subcat['name'];
$products = getProducts($subId);

include 'includes/header.php';
?>

<div class="container">
    <div class="breadcrumb">
        <a href="<?= SITE_URL ?>/">Home</a>
        <span>/</span>
        <a href="<?= SITE_URL ?>/categories.php">Products</a>
        <span>/</span>
        <a href="<?= SITE_URL ?>/category.php?id=<?= $subcat['category_id'] ?>"><?= sanitize($subcat['category_name']) ?></a>
        <span>/</span>
        <?= sanitize($subcat['name']) ?>
    </div>
</div>

<section class="section" style="padding-top:20px;">
    <div class="container">
        <div class="section-header">
            <h2><?= sanitize($subcat['name']) ?></h2>
            <?php if ($subcat['description']): ?>
            <p><?= sanitize($subcat['description']) ?></p>
            <?php endif; ?>
        </div>

        <?php if (!empty($subcat['image']) && file_exists(__DIR__ . '/' . $subcat['image'])): ?>
        <div style="text-align:center; margin-bottom:30px;">
            <img src="<?= SITE_URL ?>/<?= sanitize($subcat['image']) ?>" alt="<?= sanitize($subcat['name']) ?>" style="max-width:400px; width:100%; border-radius:12px; border:1px solid #222;">
        </div>
        <?php endif; ?>

        <?php if (empty($products)): ?>
        <div style="text-align:center; padding:40px; color:#666;">
            <p>No products in this subcategory yet.</p>
        </div>
        <?php else: ?>
        <div class="product-grid">
            <?php foreach ($products as $prod):
                $img = fetchOne("SELECT * FROM product_images WHERE product_id = ? ORDER BY sort_order LIMIT 1", [$prod['id']]);
                $fallbackImg = !empty($subcat['image']) && file_exists(__DIR__ . '/' . $subcat['image']) ? $subcat['image'] : '';
            ?>
            <a href="<?= SITE_URL ?>/product.php?id=<?= $prod['id'] ?>" class="product-card" style="text-decoration:none;">
                <div class="product-image">
                    <?php if ($img): ?>
                    <img src="<?= SITE_URL ?>/<?= sanitize($img['image_path']) ?>" alt="<?= sanitize($prod['name']) ?>">
                    <?php elseif ($fallbackImg): ?>
                    <img src="<?= SITE_URL ?>/<?= sanitize($fallbackImg) ?>" alt="<?= sanitize($prod['name']) ?>" style="opacity:0.85;">
                    <?php else: ?>
                    <div class="no-image">No Image</div>
                    <?php endif; ?>
                </div>
                <div class="product-info">
                    <h4><?= sanitize($prod['name']) ?></h4>
                    <?php if ($prod['reference_code']): ?>
                    <div class="ref">Ref: <?= sanitize($prod['reference_code']) ?></div>
                    <?php endif; ?>
                </div>
            </a>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
