# RIG & DIG CMS - Installation Guide (Shared Hosting)

## Requirements
- PHP 7.4 or higher (with PDO and MySQLi)
- MySQL 5.7 or higher
- LiteSpeed or Apache web server with mod_rewrite enabled

## Installation Steps

### 1. Create a MySQL Database
Log in to your cPanel and go to "MySQL Databases":
- Create a new database (e.g., `riganddig`)
- Create a new database user with a password
- Add the user to the database with ALL PRIVILEGES

### 2. Configure the CMS
- Rename `config.sample.php` to `config.php`
- Edit `config.php` and fill in your MySQL database details:
  - DB_HOST: usually `localhost`
  - DB_NAME: your database name
  - DB_USER: your database username
  - DB_PASS: your database password
  - SESSION_SECRET: change to any random string

### 3. Upload Files
Upload ALL files and folders to your `public_html` directory (or subdirectory) via:
- cPanel File Manager, or
- FTP client (FileZilla, etc.)

Make sure to upload hidden files too (`.htaccess`)

### 4. Set Folder Permissions
Set the `uploads/` folder to writable:
- Right-click `uploads/` in File Manager
- Set permissions to `755` or `775`

### 5. Run the Installation Wizard
Open your browser and visit:
```
https://yourdomain.com/install
```

The wizard will:
- Create all database tables automatically
- Set up your admin account
- Configure your site title and contact info

### 6. Done!
After installation:
- Your site is live at `https://yourdomain.com`
- Admin panel at `https://yourdomain.com/admin`

## File Structure
```
public_html/
  .htaccess         (URL routing rules)
  index.html        (Frontend application)
  api.php           (Backend API)
  config.php        (Your database credentials)
  favicon.png
  assets/           (CSS and JavaScript)
  images/           (Product and fleet images)
  includes/         (PHP helper files)
  uploads/          (Uploaded images - must be writable)
```

## Admin Panel Features
- Dashboard with statistics
- Fleet/Equipment management
- Oil & Gas Products catalog
- Services management
- Contact form leads
- Site settings (title, hero, contact info)

## Troubleshooting

**Blank page or 500 error:**
- Check that `.htaccess` was uploaded (it's a hidden file)
- Make sure mod_rewrite is enabled (LiteSpeed has it by default)
- Check PHP error log in cPanel

**"config.php not found" error:**
- Rename `config.sample.php` to `config.php`
- Fill in your database credentials

**Cannot connect to database:**
- Verify database name, username, and password in `config.php`
- In cPanel, make sure the user is added to the database

**Images not uploading:**
- Set `uploads/` folder permissions to 755 or 775
- Check PHP upload_max_filesize in cPanel PHP settings

**Pages show 404:**
- Verify `.htaccess` is in the root directory
- Try adding `RewriteBase /` to `.htaccess` if in a subdirectory

## Installing in a Subdirectory
If installing in a folder like `yourdomain.com/cms/`:
1. Upload files to `public_html/cms/`
2. Add this line to `.htaccess` after `RewriteEngine On`:
   ```
   RewriteBase /cms/
   ```
